<?php
/**
 * ===================================================================================
 * Main Logout Script
 * ===================================================================================
 *
 * File: logout.php
 * Location: /homework_portal/logout.php
 *
 * Purpose:
 * 1. This is the central logout script for students.
 * 2. It completely destroys the current session.
 * 3. It redirects the user back to the main student login page.
 */

// Start the session to gain access to it.
session_start();

// Unset all session variables to clear any stored data.
$_SESSION = array();

// Destroy the session from the server.
session_destroy();

// Redirect the user to the student login page in the root directory.
header('Location: login.php');
exit(); // Ensure no other code runs after the redirect.
